const express = require('express');
const nodemailer = require('nodemailer');
const path = require('path');
const app = express();

app.use(express.static(__dirname));
app.use(express.json());

app.post('/api/contact', async (req, res) => {
    const { name, email, message } = req.body;
    console.log(`Contact form submitted: Name=${name}, Email=${email}, Message=${message}`);
    try {
        let transporter = nodemailer.createTransport({
            service: 'gmail',
            auth: {
                user: 'ezeokejeremiah5@gmail.com',
                pass: 'YOUR_APP_PASSWORD' // Replace with your Gmail App Password
            }
        });

        await transporter.sendMail({
            from: email,
            to: 'ezeokejeremiah5@gmail.com',
            subject: `New Contact Message from ${name}`,
            text: `Name: ${name}\nEmail: ${email}\nMessage: ${message}`
        });

        res.json({ success: true });
    } catch (err) {
        console.error(err);
        res.json({ success: false });
    }
});

// Serve index.html for root, and static files for others
app.get('/', (req, res) => {
    res.sendFile(path.join(__dirname, 'index.html'));
});

app.get('/:file', (req, res) => {
    res.sendFile(path.join(__dirname, req.params.file));
});

app.listen(3000, () => {
    console.log('Server running on http://localhost:3000');
});